-- V2D - 12549 Messaging for DISABILITIES_ALERT_PURPOSE_OWNER Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'Disabilities Alert to Purpose Owner');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='Disabilities Alert to Purpose Owner');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'DISABILITIES_ALERT_PURPOSE_OWNER', 'DISABILITIES_ALERT_PURPOSE_OWNER', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Disabilities Alert to Purpose Owner');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DISABILITIES_ALERT_PURPOSE_OWNER_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DISABILITIES_ALERT_PURPOSE_OWNER_RECIPIENT', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISABILITIES_ALERT_PURPOSE_OWNER_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'DISABILITIES_ALERT_PURPOSE_OWNER_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISABILITIES_ALERT_PURPOSE_OWNER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DISABILITIES_ALERT_PURPOSE_OWNER_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISABILITIES_ALERT_PURPOSE_OWNER_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM application T1 WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISABILITIES_ALERT_PURPOSE_OWNER_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T3.`id` AS ID,    
    T4.`firstName` AS APPLICANT_FIRSTNAME,
    T4.`middleName` AS APPLICANT_MIDDLENAME,
    T4.`lastName` AS APPLICANT_LASTNAME,
    T16.`emailId` AS EMAIL_ID,
    T4.`emailId` AS APPLICANT_EMAIL_ID,
    T4.`mobileNumber` AS APPLICANT_MOBILE_NO,
    T3.`code` AS APPLICATION_CODE,
    T8.`displayName` AS ACADEMY_NAME_LOCATION,
    T8.`academyName` AS ACADEMY_NAME,
    T8.`locationName` AS LOCATION_NAME,
    T12.`programNameToBePrint` AS PROGRAM_PRINT_NAME,
    T11.`itemValue` AS BATCH_MODE_OF_DELIVERY,
    T13.`itemValue` AS PROGRAM_MODE_OF_DELIVERY,
    T14.`itemValue` AS PROGRAM_REGISTRATION_TYPE,
    T16.`firstName` AS MODULE_OWNER_FIRST_NAME,
    T16.`middleName` AS MODULE_OWNER_MIDDLE_NAME,
    T16.`lastName` AS MODULE_OWNER_LAST_NAME,
    (select GROUP_CONCAT(dd.value) from applicant_person_disability apd
inner join drop_down dd on dd.id = apd.haveDisabilityId and dd.type = 'HaveDisabilities' and (dd.value not in ('None','none','NONE'))
where applicantPersonId = T3.applicantPersonId
group by apd.applicantPersonId) as APPLICANT_DISABILITIES,
    (CASE
        WHEN
            T10.batchPartTime IS NOT NULL
                AND T10.batchPartTime = false
        THEN
            'Full Time'
        WHEN
            T10.batchPartTime IS NOT NULL
                AND T10.batchPartTime = true
        THEN
            'Part Time'
        ELSE null
    END) AS BATCH_REGISTRATION_TYPE,    
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    application T3
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        INNER JOIN
    academy_location_purpose T15 on T15.academyLocationId = T8.id and T15.purposeCode = 'COURSE_EXECUTION'
        INNER JOIN
    users T16 on T16.id = T15.ownerId
        LEFT OUTER JOIN
    prog_batch_seat_config T9 on T9.id = T7.progBatchSeatConfigId
        LEFT OUTER JOIN
    batches T10 on T10.id = T9.programBatchId
        LEFT OUTER JOIN
    mode_of_delivery T11 on T11.id = T10.modeOfDeliveryId
        LEFT OUTER JOIN
    programs T12 ON T12.id = T7.programId
        LEFT OUTER JOIN
    mode_of_delivery T13 on T13.id = T12.modeOfDeliveryId
        LEFT OUTER JOIN
    registration_type T14 on T14.id = T12.registrationTypeId
        LEFT OUTER JOIN        
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T3.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "acadLocPurposeOwnerFName",
            "resultKey": "MODULE_OWNER_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "acadLocPurposeOwnerMName",
            "resultKey": "MODULE_OWNER_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "acadLocPurposeOwnerLName",
            "resultKey": "MODULE_OWNER_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "applicantEmailId",
            "resultKey": "APPLICANT_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "applicantFirstName",
            "resultKey": "APPLICANT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "applicantMiddleName",
            "resultKey": "APPLICANT_MIDDLENAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "applicantLastName",
            "resultKey": "APPLICANT_LASTNAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "applicantMobileNumber",
            "resultKey": "APPLICANT_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 10            
        },
        {
            "id": 12,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "progPrintName",
            "resultKey": "PROGRAM_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "batchModeOfDelivery",
            "resultKey": "BATCH_MODE_OF_DELIVERY",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "batchRegType",
            "resultKey": "BATCH_REGISTRATION_TYPE",
            "displayCode": "",
            "displayOrder": 15            
        },        
        {
            "id": 17,
            "value": "progModeOfDelivery",
            "resultKey": "PROGRAM_MODE_OF_DELIVERY",
            "displayCode": "",
            "displayOrder": 16            
        },
        {   
            "id": 18,
            "value": "progRegType",
            "resultKey": "PROGRAM_REGISTRATION_TYPE",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 19,
            "value": "applicantDissabilities",
            "resultKey": "APPLICANT_DISABILITIES",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 19
        },
        {
            "id": 21,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 20
        }
    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='DISABILITIES_ALERT_PURPOSE_OWNER');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='Disabilities Alert to Purpose Owner');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DISABILITIES_ALERT_PURPOSE_OWNER_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Disabilities Alert to Purpose Owner',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Disabilities Alert to Purpose Owner',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','SPECIAL CONCESSION/DISABILITY: $recipientData[&quot;APPLICANT_FIRSTNAME&quot;] $recipientData[&quot;APPLICANT_LASTNAME&quot;]','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Dear <strong>$recipientData[&quot;MODULE_OWNER_FIRST_NAME&quot;] $recipientData[&quot;MODULE_OWNER_LAST_NAME&quot;]</strong>,</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Please note that applicant <strong>$recipientData[&quot;APPLICANT_FIRSTNAME&quot;] $recipientData[&quot;APPLICANT_LASTNAME&quot;]</strong> has indicated that they have the following disability:</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px"><strong> $recipientData[&quot;APPLICANT_DISABILITIES&quot;] </strong></p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Please contact them so that you can ascertain whether the campus can accommodate them.</p>
            </td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:10px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;APPLICANT_FIRSTNAME&quot;] $recipientData[&quot;APPLICANT_LASTNAME&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;APPLICATION_CODE&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;LOCATION_NAME&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;PROGRAM_PRINT_NAME&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;BATCH_MODE_OF_DELIVERY&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;BATCH_REGISTRATION_TYPE&quot;]</p>
            </td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:10px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;APPLICANT_MOBILE_NO&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">$recipientData[&quot;APPLICANT_EMAIL_ID&quot;]</p>
            </td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:14px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Thank you</p>
            </td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:14px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px"><strong>STASY APPLICATIONS CENTRE</strong></p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'');

-- End Messaging for DISABILITIES_ALERT_PURPOSE_OWNER Event